#version 330
#extension GL_EXT_gpu_shader4 : enable
//Psyche color testMod01.fsh  by trinketMage 
//https://www.shadertoy.com/view/3s2yRm
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define S(a,b,t) smoothstep(a,b,t)


float N21 (vec2 p){
	float d = fract(sin(p.x*110.+(8.21-p.y)*331.)*1218.);
    return d;
}

float Noise2D(vec2 uv){
    vec2 st = fract(uv);
    vec2 id = floor(uv);
    st = st*st*(3.0-2.0*st);
    float c=mix(mix(N21(id),N21(id+vec2(1.0,0.0)),st.x),mix(N21(id+vec2(0.0,1.0)),N21(id+vec2(1.0,1.0)),st.x),st.y);
	return c;
}

float fbm (vec2 uv){
    
    float c=0.;
	c+=Noise2D(uv)/2.;
    c+=Noise2D(2.*uv)/4.;
    return c/(1.-1./16.);
}

vec3 fbm3(vec2 uv){
    vec3 color;
	float f1 = fbm(uv);
    color= mix(vec3(0.1,0.0,0.0),vec3(0.9,0.1,0.1),2.5*f1);
    
    float f2 = fbm(2.4*f1+uv+0.15*sin(iTime)*vec2(7.0,-8.0));
    color= mix(color,vec3(0.6,0.5,0.1),1.5*f2);
    float f3 = fbm(3.5*f2+uv-0.15*cos(1.5*iTime)*vec2(4.0,3.0));
    color= mix(color,vec3(0.1,0.35,0.45),f3);
    
    return color;

}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy/iResolution.x;
    vec3 c = fbm3(vec2(5.0,5.0)*uv+sin(0.3*iTime)*0.5);
    vec3 col = c;

    col.r *= .825;
    col.g *= .825;
    gl_FragColor = vec4(col * 2.5,1.0);
}